/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.lazrslib.common.network;

import com.lazrproductions.lazrslib.common.network.base.ILazrPacket;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class LazrNetwork {
    final SimpleChannel network;
    final String version;
    private int id = 0;

    public LazrNetwork(ResourceLocation location, int version) {
        this.version = String.valueOf(version);
        this.network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)location).clientAcceptedVersions(this.version::equals).serverAcceptedVersions(this.version::equals).networkProtocolVersion(() -> this.version).simpleChannel();
    }

    public <T extends ILazrPacket> void registerClientBoundPacket(Class<T> c, Function<FriendlyByteBuf, T> decoder) {
        this.registerPacket(c, ILazrPacket::encode, decoder, ILazrPacket::handle, NetworkDirection.PLAY_TO_CLIENT);
    }

    public <T extends ILazrPacket> void registerServerBoundPacket(Class<T> c, Function<FriendlyByteBuf, T> decoder) {
        this.registerPacket(c, ILazrPacket::encode, decoder, ILazrPacket::handle, NetworkDirection.PLAY_TO_SERVER);
    }

    public <T extends ILazrPacket> void registerPacket(Class<T> c, Function<FriendlyByteBuf, T> decoder) {
        this.registerPacket(c, ILazrPacket::encode, decoder, ILazrPacket::handle, null);
    }

    public <T extends ILazrPacket> void registerPacket(Class<T> c, Function<FriendlyByteBuf, T> decoder, @Nullable NetworkDirection direction) {
        this.registerPacket(c, ILazrPacket::encode, decoder, ILazrPacket::handle, direction);
    }

    public <T extends ILazrPacket> void registerPacket(Class<T> c, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> consumer, @Nullable NetworkDirection direction) {
        this.network.registerMessage(this.id++, c, encoder, decoder, consumer, Optional.ofNullable(direction));
    }

    public void sendToServer(Object msg) {
        this.network.sendToServer(msg);
    }

    public void send(PacketDistributor.PacketTarget target, Object message) {
        this.network.send(target, message);
    }

    public void sendVanillaPacket(Packet<?> packet, Entity player) {
        if (player instanceof ServerPlayer && ((ServerPlayer)player).f_8906_ != null) {
            ((ServerPlayer)player).f_8906_.m_9829_(packet);
        }
    }

    public void sendTo(Object msg, Player player) {
        if (player instanceof ServerPlayer) {
            this.sendTo(msg, (ServerPlayer)player);
        }
    }

    public void sendTo(Object msg, ServerPlayer player) {
        if (!(player instanceof FakePlayer)) {
            this.network.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public void sendToClientsAround(Object msg, ServerLevel serverWorld, BlockPos position) {
        LevelChunk chunk = serverWorld.m_46745_(position);
        this.network.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), msg);
    }

    public void sendToTrackingAndSelf(Object msg, Entity entity) {
        this.network.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), msg);
    }

    public void sendToTracking(Object msg, Entity entity) {
        this.network.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), msg);
    }

    public void sendToClientsAround(Object msg, @Nullable LevelAccessor world, BlockPos position) {
        if (world instanceof ServerLevel) {
            this.sendToClientsAround(msg, (ServerLevel)world, position);
        }
    }
}

